package de.davidartmann.rosa.db.async;

import android.content.Context;
import android.os.AsyncTask;

import de.davidartmann.rosa.db.PersonDao;
import de.davidartmann.rosa.model.Person;

/**
 * AsyncTask to delete all inactive Persons from the DB.
 * Created by david on 06.03.16.
 */
public class DeleteAllInactivePersonsInDb extends AsyncTask<Person, Integer, Integer> {

    private Context context;
    private PersonDao personDao;
    private IDeleteAllInactivePersonsInDb iDeleteAllInactivePersonsInDb;

    public DeleteAllInactivePersonsInDb(
            Context context, IDeleteAllInactivePersonsInDb iDeleteAllInactivePersonsInDb) {
        this.context = context;
        this.iDeleteAllInactivePersonsInDb = iDeleteAllInactivePersonsInDb;
    }

    @Override
    protected Integer doInBackground(Person... persons) {
        personDao = new PersonDao(context);
        personDao.openWritable();
        return personDao.deleteAllInactive();
    }

    @Override
    protected void onPostExecute(Integer numberOfDeletedPersons) {
        super.onPostExecute(numberOfDeletedPersons);
        iDeleteAllInactivePersonsInDb.onDeletedAllInactive(numberOfDeletedPersons);
        personDao.close();
    }

    public interface IDeleteAllInactivePersonsInDb {
        void onDeletedAllInactive(Integer numberOfDeletedPersons);
    }
}
